function Figure1S2D()

load('50AF488_50Cy5.mat');
Q = median(X./Y); % Calibration factor to correct for differences in dye intensity.

c = [0.4/99.6 2/98 10/90 1 90/10 98/2 99.6/0.4];
c0 = []; c1 = [];

load('00AF488_99Cy5.mat');
[p,q] = hist(log10(X./Y),50); p = p/(5*max(p)); i = find(p<.001); q(i) = []; p(i) = [];
C = log10(c(1));
plot([C+p fliplr(C-p)],[q fliplr(q)]); drawnow; hold on;
plot(C,C+log10(Q),'sk');
plot([C-.1 C+.1],median(log10(X./Y))*[1 1],'k');
c0 = [c0 C];
c1 = [c1 C+log10(Q)];

load('02AF488_98Cy5.mat');
[p,q] = hist(log10(X./Y),50); p = p/(5*max(p)); i = find(p<.001); q(i) = []; p(i) = [];
C = log10(c(2));
plot([C+p fliplr(C-p)],[q fliplr(q)]); drawnow; hold on;
plot(C,C+log10(Q),'sk');
plot([C-.1 C+.1],median(log10(X./Y))*[1 1],'k');
c0 = [c0 C];
c1 = [c1 C+log10(Q)];

load('10AF488_90Cy5.mat');
[p,q] = hist(log10(X./Y),50); p = p/(5*max(p)); i = find(p<.001); q(i) = []; p(i) = [];
C = log10(c(3));
plot([C+p fliplr(C-p)],[q fliplr(q)]); drawnow; hold on;
plot(C,C+log10(Q),'sk');
plot([C-.1 C+.1],median(log10(X./Y))*[1 1],'k');
c0 = [c0 C];
c1 = [c1 C+log10(Q)];

load('50AF488_50Cy5.mat');
[p,q] = hist(log10(X./Y),50); p = p/(5*max(p)); i = find(p<.001); q(i) = []; p(i) = [];
C = log10(c(4));
plot([C+p fliplr(C-p)],[q fliplr(q)]); drawnow; hold on;
plot(C,C+log10(Q),'sk');
plot([C-.1 C+.1],median(log10(X./Y))*[1 1],'k');
c0 = [c0 C];
c1 = [c1 C+log10(Q)];

load('90AF488_10Cy5.mat');
[p,q] = hist(log10(X./Y),50); p = p/(5*max(p)); i = find(p<.001); q(i) = []; p(i) = [];
C = log10(c(5));
plot([C+p fliplr(C-p)],[q fliplr(q)]); drawnow; hold on;
plot(C,C+log10(Q),'sk');
plot([C-.1 C+.1],median(log10(X./Y))*[1 1],'k');
c0 = [c0 C];
c1 = [c1 C+log10(Q)];

load('98AF488_02Cy5.mat');
[p,q] = hist(log10(X./Y),50); p = p/(5*max(p)); i = find(p<.001); q(i) = []; p(i) = [];
C = log10(c(6));
plot([C+p fliplr(C-p)],[q fliplr(q)]); drawnow; hold on;
plot(C,C+log10(Q),'sk');
plot([C-.1 C+.1],median(log10(X./Y))*[1 1],'k');
c0 = [c0 C];
c1 = [c1 C+log10(Q)];

load('99AF488_00Cy5.mat');
[p,q] = hist(log10(X./Y),50); p = p/(5*max(p)); i = find(p<.001); q(i) = []; p(i) = [];
C = log10(c(7));
plot([C+p fliplr(C-p)],[q fliplr(q)]); drawnow; hold on;
plot(C,C+log10(Q),'sk');
plot([C-.1 C+.1],median(log10(X./Y))*[1 1],'k');
c0 = [c0 C];
c1 = [c1 C+log10(Q)];

plot(c0,c1,':'); axis square;
xlabel('log10 AF488/Cy5 input concentration');
ylabel('log10 AF488/Cy5 intensities per particle');